// Converted from guest(r)'s shader

/*
[configuration]
[OptionBool]
GUIName = AA 4.0
OptionName = AA
DefaultValue = true

[OptionRangeFloat]
GUIName = Additional Effects
OptionName = OGL2PARAM
MinValue = 1.0
MaxValue = 4.0
StepAmount = 1
DefaultValue = 1.0
DependantOption = AA

[OptionRangeFloat]
GUIName = blur
OptionName = blur
MinValue = 0.0
MaxValue = 2.0
StepAmount = 0.05
DefaultValue = 1.0
DependantOption = AA
[/configuration]
*/

float bloom = 0.50;
float natural = 1.15;
const float3 dt = float3(1.0,1.0,1.0);
uniform mat3 RGBtoYIQ = mat3(0.299, 0.596, 0.212, 
                           0.587,-0.275,-0.523, 
                           0.114,-0.321, 0.311);

uniform mat3 YIQtoRGB = mat3(1.000, 1.000, 1.000,
                           0.955,-0.271,-1.108,
                           0.619,-0.646, 1.705);
float2 texSize = GetResolution();				
float4 yx = GetOption(blur) * float4(GetInvResolution().x,GetInvResolution().y,-GetInvResolution().x,-GetInvResolution().y); // make yx smaller, x0.5 or 0.25?
//orig: float4 yx = float4(1.0/4096,1.0/2048,-1.0/4096,-1.0/2048); //vary based on res?

float3 texture2d (float2 texcoord) {
	float3 s00 = SampleLocation(texcoord + yx.zw).xyz; 
	float3 s20 = SampleLocation(texcoord + yx.xw).xyz; 
	float3 s22 = SampleLocation(texcoord + yx.xy).xyz; 
	float3 s02 = SampleLocation(texcoord + yx.zy).xyz; 

	float m1=dot(abs(s00-s22),dt)+0.001;
	float m2=dot(abs(s02-s20),dt)+0.001;

	return .5*(m2*(s00+s22)+m1*(s02+s20))/(m1+m2);
}

void main()
{
	float4 Color = Sample();
	if (OptionEnabled(AA)) {

// Calculating texel coordinates
	//orig: float2 size = float2(4096.0,2048.0);
	//float2 size = internal res?
	float2 size = GetResolution(); // internal res
	float2 inv_size = GetInvResolution();
	
	float2 OGL2Pos = GetCoordinates().xy * size; // bad? Leads to blur
	float2 fp = frac(OGL2Pos);
	float2 dx = float2(inv_size.x,0.0);
	float2 dy = float2(0.0, inv_size.y);
	float2 g1 = inv_size;
	float2 g2 = float2(-inv_size.x,inv_size.y);
	
	float2 pC4 = GetCoordinates(); //floor(OGL2Pos) * inv_size;	
	
	// Reading the texels
	float3 C0 = texture2d(pC4 - g1); 
	float3 C1 = texture2d(pC4 - dy);
	float3 C2 = texture2d(pC4 - g2);
	float3 C3 = texture2d(pC4 - dx);
	float3 C4 = texture2d(pC4     );
	float3 C5 = texture2d(pC4 + dx);
	float3 C6 = texture2d(pC4 + g2);
	float3 C7 = texture2d(pC4 + dy);
	float3 C8 = texture2d(pC4 + g1);
	
	float3 ul, ur, dl, dr;
	float m1, m2;
	
	m1 = dot(abs(C0-C4),dt)+0.001;
	m2 = dot(abs(C1-C3),dt)+0.001;
	ul = (m2*(C0+C4)+m1*(C1+C3))/(m1+m2);  
	
	m1 = dot(abs(C1-C5),dt)+0.001;
	m2 = dot(abs(C2-C4),dt)+0.001;
	ur = (m2*(C1+C5)+m1*(C2+C4))/(m1+m2);
	
	m1 = dot(abs(C3-C7),dt)+0.001;
	m2 = dot(abs(C6-C4),dt)+0.001;
	dl = (m2*(C3+C7)+m1*(C6+C4))/(m1+m2);
	
	m1 = dot(abs(C4-C8),dt)+0.001;
	m2 = dot(abs(C5-C7),dt)+0.001;
	dr = (m2*(C4+C8)+m1*(C5+C7))/(m1+m2);
	
	float3 c11 = 0.5*((dr*fp.x+dl*(1-fp.x))*fp.y+(ur*fp.x+ul*(1-fp.x))*(1-fp.y) );

	if  (GetOption(OGL2PARAM) < 2.0) natural = 1.0;
	c11=RGBtoYIQ*c11;
	c11=float3(pow(c11.x,natural),c11.yz*natural);
	c11=YIQtoRGB*c11;
	float k1 = length(c11); 
	bloom = mod(GetOption(OGL2PARAM),2)*bloom;
	Color.xyz = (1.0-bloom)*c11 + bloom*mix(k1,normalize(float2(k1*k1,0.82)).x*1.74,0.577*k1)*normalize(c11);
	}
	SetOutput(Color);
}